#include "shaders.h"

CShader::CShader()
{
	Shader = 0;
}

CShader::operator GLuint ()
{
	return Shader;
}

bool CShader::Load(char *FileName, GLenum Type)
{
    char *DirectoryFileName = new char[256];

    GetModuleFileName(GetModuleHandle(NULL), DirectoryFileName, 256);

    *(strrchr(DirectoryFileName, '\\') + 1) = 0;
	strcat(DirectoryFileName, "Shaders\\");
	strcat(DirectoryFileName, FileName);

	FILE *File = fopen(DirectoryFileName, "rb");

	delete [] DirectoryFileName;

	if(File == NULL)
	{
		return false;
	}

    fseek(File, 0, SEEK_END);
    long Size = ftell(File);
    fseek(File, 0, SEEK_SET);
    char *Source = new char[Size + 1];
    fread(Source, 1, Size, File);
    fclose(File);
    Source[Size] = 0;

	Shader = glCreateShader(Type);

	glShaderSource(Shader, 1, (const char**)&Source, NULL);
	delete [] Source;
	glCompileShader(Shader);

	int CompileStatus;
	glGetShaderiv(Shader, GL_COMPILE_STATUS, &CompileStatus);

	if(CompileStatus == GL_FALSE)
	{
		return false;
	}

	return true;
}

CShaderProgram::CShaderProgram()
{
	Program = 0;
}

CShaderProgram::operator GLuint ()
{
	return Program;
}

bool CShaderProgram::Load(char *VertexShaderFileName, char *FragmentShaderFileName)
{
	if(!VertexShader.Load(VertexShaderFileName, GL_VERTEX_SHADER))
	{
		return false;
	}

	if(!FragmentShader.Load(FragmentShaderFileName, GL_FRAGMENT_SHADER))
	{
		return false;
	}

	Program = glCreateProgram();
	glAttachShader(Program, VertexShader);
	glAttachShader(Program, FragmentShader);
	glLinkProgram(Program);

	int LinkStatus;
	glGetProgramiv(Program, GL_LINK_STATUS, &LinkStatus);

	if(LinkStatus == GL_FALSE)
	{
		return false;
	}

	return true;
}

void CShaderProgram::Destroy()
{
	glDetachShader(Program, VertexShader);
	glDetachShader(Program, FragmentShader);
	glDeleteShader(VertexShader);
	glDeleteShader(FragmentShader);
	glDeleteProgram(Program);
}
